package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectName,
  GlossaryTermId,
  DomainId,
  Description
}
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    name: ProjectName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateProjectRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateProjectRequest.ReadOnly =
    zio.aws.datazone.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateProjectRequest =
      zio.aws.datazone.model.CreateProjectRequest(
        description.map(value => value),
        domainIdentifier,
        glossaryTerms.map(value => value),
        name
      )
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def name: ProjectName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateProjectRequest
  ) extends zio.aws.datazone.model.CreateProjectRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val name: ProjectName =
      zio.aws.datazone.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateProjectRequest
  ): zio.aws.datazone.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
