package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.AssetId
import scala.jdk.CollectionConverters._
final case class AssetTargetNameMap(assetId: AssetId, targetName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetTargetNameMap = {
    import AssetTargetNameMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetTargetNameMap
      .builder()
      .assetId(AssetId.unwrap(assetId): java.lang.String)
      .targetName(targetName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetTargetNameMap.ReadOnly =
    zio.aws.datazone.model.AssetTargetNameMap.wrap(buildAwsValue())
}
object AssetTargetNameMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetTargetNameMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetTargetNameMap =
      zio.aws.datazone.model.AssetTargetNameMap(assetId, targetName)
    def assetId: AssetId
    def targetName: String
    def getAssetId: ZIO[Any, Nothing, AssetId] = ZIO.succeed(assetId)
    def getTargetName: ZIO[Any, Nothing, String] = ZIO.succeed(targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetTargetNameMap
  ) extends zio.aws.datazone.model.AssetTargetNameMap.ReadOnly {
    override val assetId: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.assetId())
    override val targetName: String = impl.targetName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetTargetNameMap
  ): zio.aws.datazone.model.AssetTargetNameMap.ReadOnly = new Wrapper(impl)
}
