package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  DomainId,
  EnvironmentId,
  TypeName,
  AuthorizedPrincipalIdentifier,
  SubscriptionTargetId,
  SubscriptionTargetName
}
import scala.jdk.CollectionConverters._
final case class UpdateSubscriptionTargetRequest(
    applicableAssetTypes: Optional[Iterable[TypeName]] = Optional.Absent,
    authorizedPrincipals: Optional[Iterable[AuthorizedPrincipalIdentifier]] =
      Optional.Absent,
    domainIdentifier: DomainId,
    environmentIdentifier: EnvironmentId,
    identifier: SubscriptionTargetId,
    manageAccessRole: Optional[String] = Optional.Absent,
    name: Optional[SubscriptionTargetName] = Optional.Absent,
    provider: Optional[String] = Optional.Absent,
    subscriptionTargetConfig: Optional[
      Iterable[zio.aws.datazone.model.SubscriptionTargetForm]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest = {
    import UpdateSubscriptionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest
      .builder()
      .optionallyWith(
        applicableAssetTypes.map(value =>
          value.map { item =>
            TypeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicableAssetTypes)
      .optionallyWith(
        authorizedPrincipals.map(value =>
          value.map { item =>
            AuthorizedPrincipalIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authorizedPrincipals)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .identifier(SubscriptionTargetId.unwrap(identifier): java.lang.String)
      .optionallyWith(manageAccessRole.map(value => value: java.lang.String))(
        _.manageAccessRole
      )
      .optionallyWith(
        name.map(value =>
          SubscriptionTargetName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .optionallyWith(
        subscriptionTargetConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptionTargetConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.UpdateSubscriptionTargetRequest.ReadOnly =
    zio.aws.datazone.model.UpdateSubscriptionTargetRequest.wrap(buildAwsValue())
}
object UpdateSubscriptionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateSubscriptionTargetRequest =
      zio.aws.datazone.model.UpdateSubscriptionTargetRequest(
        applicableAssetTypes.map(value => value),
        authorizedPrincipals.map(value => value),
        domainIdentifier,
        environmentIdentifier,
        identifier,
        manageAccessRole.map(value => value),
        name.map(value => value),
        provider.map(value => value),
        subscriptionTargetConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicableAssetTypes: Optional[List[TypeName]]
    def authorizedPrincipals: Optional[List[AuthorizedPrincipalIdentifier]]
    def domainIdentifier: DomainId
    def environmentIdentifier: EnvironmentId
    def identifier: SubscriptionTargetId
    def manageAccessRole: Optional[String]
    def name: Optional[SubscriptionTargetName]
    def provider: Optional[String]
    def subscriptionTargetConfig
        : Optional[List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly]]
    def getApplicableAssetTypes: ZIO[Any, AwsError, List[TypeName]] =
      AwsError.unwrapOptionField("applicableAssetTypes", applicableAssetTypes)
    def getAuthorizedPrincipals
        : ZIO[Any, AwsError, List[AuthorizedPrincipalIdentifier]] =
      AwsError.unwrapOptionField("authorizedPrincipals", authorizedPrincipals)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionTargetId] =
      ZIO.succeed(identifier)
    def getManageAccessRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("manageAccessRole", manageAccessRole)
    def getName: ZIO[Any, AwsError, SubscriptionTargetName] =
      AwsError.unwrapOptionField("name", name)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getSubscriptionTargetConfig: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "subscriptionTargetConfig",
      subscriptionTargetConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest
  ) extends zio.aws.datazone.model.UpdateSubscriptionTargetRequest.ReadOnly {
    override val applicableAssetTypes: Optional[List[TypeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicableAssetTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.TypeName(item)
          }.toList
        )
    override val authorizedPrincipals
        : Optional[List[AuthorizedPrincipalIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizedPrincipals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.primitives.AuthorizedPrincipalIdentifier(item)
        }.toList
      )
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.datazone.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val identifier: SubscriptionTargetId =
      zio.aws.datazone.model.primitives.SubscriptionTargetId(impl.identifier())
    override val manageAccessRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.manageAccessRole())
      .map(value => value: String)
    override val name: Optional[SubscriptionTargetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.datazone.model.primitives.SubscriptionTargetName(value)
      )
    override val provider: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => value: String)
    override val subscriptionTargetConfig: Optional[
      List[zio.aws.datazone.model.SubscriptionTargetForm.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionTargetConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.SubscriptionTargetForm.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionTargetRequest
  ): zio.aws.datazone.model.UpdateSubscriptionTargetRequest.ReadOnly =
    new Wrapper(impl)
}
