package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Name,
  DataSourceId,
  DomainId,
  Description
}
import scala.jdk.CollectionConverters._
final case class UpdateDataSourceRequest(
    assetFormsInput: Optional[Iterable[zio.aws.datazone.model.FormInput]] =
      Optional.Absent,
    configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationInput
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      Optional.Absent,
    identifier: DataSourceId,
    name: Optional[Name] = Optional.Absent,
    publishOnImport: Optional[Boolean] = Optional.Absent,
    recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration
    ] = Optional.Absent,
    schedule: Optional[zio.aws.datazone.model.ScheduleConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest = {
    import UpdateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest
      .builder()
      .optionallyWith(
        assetFormsInput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetFormsInput)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(enableSetting.map(value => value.unwrap))(_.enableSetting)
      .identifier(DataSourceId.unwrap(identifier): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(publishOnImport.map(value => value: java.lang.Boolean))(
        _.publishOnImport
      )
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateDataSourceRequest.ReadOnly =
    zio.aws.datazone.model.UpdateDataSourceRequest.wrap(buildAwsValue())
}
object UpdateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateDataSourceRequest =
      zio.aws.datazone.model.UpdateDataSourceRequest(
        assetFormsInput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        domainIdentifier,
        enableSetting.map(value => value),
        identifier,
        name.map(value => value),
        publishOnImport.map(value => value),
        recommendation.map(value => value.asEditable),
        schedule.map(value => value.asEditable)
      )
    def assetFormsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]]
    def configuration
        : Optional[zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly]
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def enableSetting: Optional[zio.aws.datazone.model.EnableSetting]
    def identifier: DataSourceId
    def name: Optional[Name]
    def publishOnImport: Optional[Boolean]
    def recommendation
        : Optional[zio.aws.datazone.model.RecommendationConfiguration.ReadOnly]
    def schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly]
    def getAssetFormsInput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      AwsError.unwrapOptionField("assetFormsInput", assetFormsInput)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnableSetting
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnableSetting] =
      AwsError.unwrapOptionField("enableSetting", enableSetting)
    def getIdentifier: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPublishOnImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publishOnImport", publishOnImport)
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ScheduleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest
  ) extends zio.aws.datazone.model.UpdateDataSourceRequest.ReadOnly {
    override val assetFormsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetFormsInput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormInput.wrap(item)
          }.toList
        )
    override val configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.datazone.model.DataSourceConfigurationInput.wrap(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSetting())
        .map(value => zio.aws.datazone.model.EnableSetting.wrap(value))
    override val identifier: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.identifier())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.Name(value))
    override val publishOnImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publishOnImport())
      .map(value => value: Boolean)
    override val recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendation())
      .map(value =>
        zio.aws.datazone.model.RecommendationConfiguration.wrap(value)
      )
    override val schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datazone.model.ScheduleConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDataSourceRequest
  ): zio.aws.datazone.model.UpdateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
