package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{ProjectName, ProjectId}
import scala.jdk.CollectionConverters._
final case class SubscribedProject(
    id: Optional[ProjectId] = Optional.Absent,
    name: Optional[ProjectName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedProject = {
    import SubscribedProject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedProject
      .builder()
      .optionallyWith(
        id.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedProject.ReadOnly =
    zio.aws.datazone.model.SubscribedProject.wrap(buildAwsValue())
}
object SubscribedProject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedProject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedProject =
      zio.aws.datazone.model
        .SubscribedProject(id.map(value => value), name.map(value => value))
    def id: Optional[ProjectId]
    def name: Optional[ProjectName]
    def getId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedProject
  ) extends zio.aws.datazone.model.SubscribedProject.ReadOnly {
    override val id: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val name: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.ProjectName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedProject
  ): zio.aws.datazone.model.SubscribedProject.ReadOnly = new Wrapper(impl)
}
