package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubscribedListingItem(
    assetListing: Optional[zio.aws.datazone.model.SubscribedAssetListing] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedListingItem = {
    import SubscribedListingItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedListingItem
      .builder()
      .optionallyWith(assetListing.map(value => value.buildAwsValue()))(
        _.assetListing
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedListingItem.ReadOnly =
    zio.aws.datazone.model.SubscribedListingItem.wrap(buildAwsValue())
}
object SubscribedListingItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedListingItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedListingItem =
      zio.aws.datazone.model
        .SubscribedListingItem(assetListing.map(value => value.asEditable))
    def assetListing
        : Optional[zio.aws.datazone.model.SubscribedAssetListing.ReadOnly]
    def getAssetListing: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.SubscribedAssetListing.ReadOnly
    ] = AwsError.unwrapOptionField("assetListing", assetListing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListingItem
  ) extends zio.aws.datazone.model.SubscribedListingItem.ReadOnly {
    override val assetListing
        : Optional[zio.aws.datazone.model.SubscribedAssetListing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetListing())
        .map(value => zio.aws.datazone.model.SubscribedAssetListing.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListingItem
  ): zio.aws.datazone.model.SubscribedListingItem.ReadOnly = new Wrapper(impl)
}
