package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{UserProfileName, LastName, FirstName}
import scala.jdk.CollectionConverters._
final case class SsoUserProfileDetails(
    firstName: Optional[FirstName] = Optional.Absent,
    lastName: Optional[LastName] = Optional.Absent,
    username: Optional[UserProfileName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails = {
    import SsoUserProfileDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails
      .builder()
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        username.map(value => UserProfileName.unwrap(value): java.lang.String)
      )(_.username)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly =
    zio.aws.datazone.model.SsoUserProfileDetails.wrap(buildAwsValue())
}
object SsoUserProfileDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SsoUserProfileDetails =
      zio.aws.datazone.model.SsoUserProfileDetails(
        firstName.map(value => value),
        lastName.map(value => value),
        username.map(value => value)
      )
    def firstName: Optional[FirstName]
    def lastName: Optional[LastName]
    def username: Optional[UserProfileName]
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getUsername: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails
  ) extends zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly {
    override val firstName: Optional[FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.datazone.model.primitives.FirstName(value))
    override val lastName: Optional[LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.datazone.model.primitives.LastName(value))
    override val username: Optional[UserProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.datazone.model.primitives.UserProfileName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails
  ): zio.aws.datazone.model.SsoUserProfileDetails.ReadOnly = new Wrapper(impl)
}
