package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{PaginationToken, MaxResults, DomainId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchListingsRequest(
    additionalAttributes: Optional[
      Iterable[zio.aws.datazone.model.SearchOutputAdditionalAttribute]
    ] = Optional.Absent,
    domainIdentifier: DomainId,
    filters: Optional[zio.aws.datazone.model.FilterClause] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    searchIn: Optional[Iterable[zio.aws.datazone.model.SearchInItem]] =
      Optional.Absent,
    searchText: Optional[String] = Optional.Absent,
    sort: Optional[zio.aws.datazone.model.SearchSort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchListingsRequest = {
    import SearchListingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchListingsRequest
      .builder()
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalAttributesWithStrings)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        searchIn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.searchIn)
      .optionallyWith(searchText.map(value => value: java.lang.String))(
        _.searchText
      )
      .optionallyWith(sort.map(value => value.buildAwsValue()))(_.sort)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchListingsRequest.ReadOnly =
    zio.aws.datazone.model.SearchListingsRequest.wrap(buildAwsValue())
}
object SearchListingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchListingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchListingsRequest =
      zio.aws.datazone.model.SearchListingsRequest(
        additionalAttributes.map(value => value),
        domainIdentifier,
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchIn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        searchText.map(value => value),
        sort.map(value => value.asEditable)
      )
    def additionalAttributes
        : Optional[List[zio.aws.datazone.model.SearchOutputAdditionalAttribute]]
    def domainIdentifier: DomainId
    def filters: Optional[zio.aws.datazone.model.FilterClause.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def searchIn: Optional[List[zio.aws.datazone.model.SearchInItem.ReadOnly]]
    def searchText: Optional[String]
    def sort: Optional[zio.aws.datazone.model.SearchSort.ReadOnly]
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SearchOutputAdditionalAttribute
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFilters
        : ZIO[Any, AwsError, zio.aws.datazone.model.FilterClause.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchIn: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SearchInItem.ReadOnly
    ]] = AwsError.unwrapOptionField("searchIn", searchIn)
    def getSearchText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("searchText", searchText)
    def getSort
        : ZIO[Any, AwsError, zio.aws.datazone.model.SearchSort.ReadOnly] =
      AwsError.unwrapOptionField("sort", sort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchListingsRequest
  ) extends zio.aws.datazone.model.SearchListingsRequest.ReadOnly {
    override val additionalAttributes: Optional[
      List[zio.aws.datazone.model.SearchOutputAdditionalAttribute]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.SearchOutputAdditionalAttribute.wrap(item)
        }.toList
      )
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val filters
        : Optional[zio.aws.datazone.model.FilterClause.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.datazone.model.FilterClause.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val searchIn
        : Optional[List[zio.aws.datazone.model.SearchInItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchIn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.SearchInItem.wrap(item)
          }.toList
        )
    override val searchText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.searchText())
      .map(value => value: String)
    override val sort: Optional[zio.aws.datazone.model.SearchSort.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.datazone.model.SearchSort.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchListingsRequest
  ): zio.aws.datazone.model.SearchListingsRequest.ReadOnly = new Wrapper(impl)
}
