package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  GroupSearchText,
  PaginationToken,
  MaxResults,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchGroupProfilesRequest(
    domainIdentifier: DomainId,
    groupType: zio.aws.datazone.model.GroupSearchType,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    searchText: Optional[GroupSearchText] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest = {
    import SearchGroupProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .groupType(groupType.unwrap)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        searchText.map(value => GroupSearchText.unwrap(value): java.lang.String)
      )(_.searchText)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchGroupProfilesRequest.ReadOnly =
    zio.aws.datazone.model.SearchGroupProfilesRequest.wrap(buildAwsValue())
}
object SearchGroupProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchGroupProfilesRequest =
      zio.aws.datazone.model.SearchGroupProfilesRequest(
        domainIdentifier,
        groupType,
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchText.map(value => value)
      )
    def domainIdentifier: DomainId
    def groupType: zio.aws.datazone.model.GroupSearchType
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def searchText: Optional[GroupSearchText]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGroupType
        : ZIO[Any, Nothing, zio.aws.datazone.model.GroupSearchType] =
      ZIO.succeed(groupType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchText: ZIO[Any, AwsError, GroupSearchText] =
      AwsError.unwrapOptionField("searchText", searchText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest
  ) extends zio.aws.datazone.model.SearchGroupProfilesRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val groupType: zio.aws.datazone.model.GroupSearchType =
      zio.aws.datazone.model.GroupSearchType.wrap(impl.groupType())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val searchText: Optional[GroupSearchText] = zio.aws.core.internal
      .optionalFromNullable(impl.searchText())
      .map(value => zio.aws.datazone.model.primitives.GroupSearchText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest
  ): zio.aws.datazone.model.SearchGroupProfilesRequest.ReadOnly = new Wrapper(
    impl
  )
}
