package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  RelationalFilterConfigurationSchemaNameString,
  RelationalFilterConfigurationDatabaseNameString
}
import scala.jdk.CollectionConverters._
final case class RelationalFilterConfiguration(
    databaseName: RelationalFilterConfigurationDatabaseNameString,
    filterExpressions: Optional[
      Iterable[zio.aws.datazone.model.FilterExpression]
    ] = Optional.Absent,
    schemaName: Optional[RelationalFilterConfigurationSchemaNameString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration = {
    import RelationalFilterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration
      .builder()
      .databaseName(
        RelationalFilterConfigurationDatabaseNameString.unwrap(
          databaseName
        ): java.lang.String
      )
      .optionallyWith(
        filterExpressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterExpressions)
      .optionallyWith(
        schemaName.map(value =>
          RelationalFilterConfigurationSchemaNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.schemaName)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly =
    zio.aws.datazone.model.RelationalFilterConfiguration.wrap(buildAwsValue())
}
object RelationalFilterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RelationalFilterConfiguration =
      zio.aws.datazone.model.RelationalFilterConfiguration(
        databaseName,
        filterExpressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schemaName.map(value => value)
      )
    def databaseName: RelationalFilterConfigurationDatabaseNameString
    def filterExpressions
        : Optional[List[zio.aws.datazone.model.FilterExpression.ReadOnly]]
    def schemaName: Optional[RelationalFilterConfigurationSchemaNameString]
    def getDatabaseName
        : ZIO[Any, Nothing, RelationalFilterConfigurationDatabaseNameString] =
      ZIO.succeed(databaseName)
    def getFilterExpressions: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.FilterExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("filterExpressions", filterExpressions)
    def getSchemaName
        : ZIO[Any, AwsError, RelationalFilterConfigurationSchemaNameString] =
      AwsError.unwrapOptionField("schemaName", schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration
  ) extends zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly {
    override val databaseName: RelationalFilterConfigurationDatabaseNameString =
      zio.aws.datazone.model.primitives
        .RelationalFilterConfigurationDatabaseNameString(impl.databaseName())
    override val filterExpressions
        : Optional[List[zio.aws.datazone.model.FilterExpression.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterExpressions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FilterExpression.wrap(item)
          }.toList
        )
    override val schemaName
        : Optional[RelationalFilterConfigurationSchemaNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaName())
        .map(value =>
          zio.aws.datazone.model.primitives
            .RelationalFilterConfigurationSchemaNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration
  ): zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly =
    new Wrapper(impl)
}
