package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GroupIdentifier, DomainId}
import scala.jdk.CollectionConverters._
final case class GetGroupProfileRequest(
    domainIdentifier: DomainId,
    groupIdentifier: GroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest = {
    import GetGroupProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .groupIdentifier(
        GroupIdentifier.unwrap(groupIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetGroupProfileRequest.ReadOnly =
    zio.aws.datazone.model.GetGroupProfileRequest.wrap(buildAwsValue())
}
object GetGroupProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetGroupProfileRequest =
      zio.aws.datazone.model
        .GetGroupProfileRequest(domainIdentifier, groupIdentifier)
    def domainIdentifier: DomainId
    def groupIdentifier: GroupIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGroupIdentifier: ZIO[Any, Nothing, GroupIdentifier] =
      ZIO.succeed(groupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest
  ) extends zio.aws.datazone.model.GetGroupProfileRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val groupIdentifier: GroupIdentifier =
      zio.aws.datazone.model.primitives.GroupIdentifier(impl.groupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetGroupProfileRequest
  ): zio.aws.datazone.model.GetGroupProfileRequest.ReadOnly = new Wrapper(impl)
}
