package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{EnvironmentBlueprintId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetEnvironmentBlueprintRequest(
    domainIdentifier: DomainId,
    identifier: EnvironmentBlueprintId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest = {
    import GetEnvironmentBlueprintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(EnvironmentBlueprintId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.GetEnvironmentBlueprintRequest.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentBlueprintRequest.wrap(buildAwsValue())
}
object GetEnvironmentBlueprintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentBlueprintRequest =
      zio.aws.datazone.model
        .GetEnvironmentBlueprintRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: EnvironmentBlueprintId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest
  ) extends zio.aws.datazone.model.GetEnvironmentBlueprintRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentBlueprintRequest
  ): zio.aws.datazone.model.GetEnvironmentBlueprintRequest.ReadOnly =
    new Wrapper(impl)
}
