package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{DataSourceId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetDataSourceRequest(
    domainIdentifier: DomainId,
    identifier: DataSourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetDataSourceRequest = {
    import GetDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetDataSourceRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(DataSourceId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetDataSourceRequest.ReadOnly =
    zio.aws.datazone.model.GetDataSourceRequest.wrap(buildAwsValue())
}
object GetDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetDataSourceRequest =
      zio.aws.datazone.model.GetDataSourceRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: DataSourceId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetDataSourceRequest
  ) extends zio.aws.datazone.model.GetDataSourceRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetDataSourceRequest
  ): zio.aws.datazone.model.GetDataSourceRequest.ReadOnly = new Wrapper(impl)
}
