package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{ListingId, DomainId}
import scala.jdk.CollectionConverters._
final case class DeleteListingRequest(
    domainIdentifier: DomainId,
    identifier: ListingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteListingRequest = {
    import DeleteListingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteListingRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(ListingId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteListingRequest.ReadOnly =
    zio.aws.datazone.model.DeleteListingRequest.wrap(buildAwsValue())
}
object DeleteListingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteListingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteListingRequest =
      zio.aws.datazone.model.DeleteListingRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: ListingId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, ListingId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteListingRequest
  ) extends zio.aws.datazone.model.DeleteListingRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteListingRequest
  ): zio.aws.datazone.model.DeleteListingRequest.ReadOnly = new Wrapper(impl)
}
