package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  EnvironmentId,
  GlossaryTermId,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    description: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    identifier: EnvironmentId,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .identifier(EnvironmentId.unwrap(identifier): java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.datazone.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateEnvironmentRequest =
      zio.aws.datazone.model.UpdateEnvironmentRequest(
        description.map(value => value),
        domainIdentifier,
        glossaryTerms.map(value => value),
        identifier,
        name.map(value => value)
      )
    def description: Optional[String]
    def domainIdentifier: DomainId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def identifier: EnvironmentId
    def name: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest
  ) extends zio.aws.datazone.model.UpdateEnvironmentRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val identifier: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.identifier())
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateEnvironmentRequest
  ): zio.aws.datazone.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
