package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Forms, TypeName, Revision, AssetId}
import scala.jdk.CollectionConverters._
final case class SubscribedAssetListing(
    entityId: Optional[AssetId] = Optional.Absent,
    entityRevision: Optional[Revision] = Optional.Absent,
    entityType: Optional[TypeName] = Optional.Absent,
    forms: Optional[Forms] = Optional.Absent,
    glossaryTerms: Optional[
      Iterable[zio.aws.datazone.model.DetailedGlossaryTerm]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedAssetListing = {
    import SubscribedAssetListing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedAssetListing
      .builder()
      .optionallyWith(
        entityId.map(value => AssetId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        entityRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.entityRevision)
      .optionallyWith(
        entityType.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.entityType)
      .optionallyWith(
        forms.map(value => Forms.unwrap(value): java.lang.String)
      )(_.forms)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedAssetListing.ReadOnly =
    zio.aws.datazone.model.SubscribedAssetListing.wrap(buildAwsValue())
}
object SubscribedAssetListing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedAssetListing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedAssetListing =
      zio.aws.datazone.model.SubscribedAssetListing(
        entityId.map(value => value),
        entityRevision.map(value => value),
        entityType.map(value => value),
        forms.map(value => value),
        glossaryTerms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entityId: Optional[AssetId]
    def entityRevision: Optional[Revision]
    def entityType: Optional[TypeName]
    def forms: Optional[Forms]
    def glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]]
    def getEntityId: ZIO[Any, AwsError, AssetId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getEntityRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("entityRevision", entityRevision)
    def getEntityType: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("entityType", entityType)
    def getForms: ZIO[Any, AwsError, Forms] =
      AwsError.unwrapOptionField("forms", forms)
    def getGlossaryTerms: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedAssetListing
  ) extends zio.aws.datazone.model.SubscribedAssetListing.ReadOnly {
    override val entityId: Optional[AssetId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.datazone.model.primitives.AssetId(value))
    override val entityRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
    override val entityType: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.entityType())
      .map(value => zio.aws.datazone.model.primitives.TypeName(value))
    override val forms: Optional[Forms] = zio.aws.core.internal
      .optionalFromNullable(impl.forms())
      .map(value => zio.aws.datazone.model.primitives.Forms(value))
    override val glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.DetailedGlossaryTerm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedAssetListing
  ): zio.aws.datazone.model.SubscribedAssetListing.ReadOnly = new Wrapper(impl)
}
