package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait SortKey {
  def unwrap: software.amazon.awssdk.services.datazone.model.SortKey
}
object SortKey {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.SortKey
  ): zio.aws.datazone.model.SortKey = value match {
    case software.amazon.awssdk.services.datazone.model.SortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.SortKey.CREATED_AT =>
      val r = CREATED_AT
      r
    case software.amazon.awssdk.services.datazone.model.SortKey.UPDATED_AT =>
      val r = UPDATED_AT
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.SortKey {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortKey =
      software.amazon.awssdk.services.datazone.model.SortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED_AT extends zio.aws.datazone.model.SortKey {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortKey =
      software.amazon.awssdk.services.datazone.model.SortKey.CREATED_AT
  }
  case object UPDATED_AT extends zio.aws.datazone.model.SortKey {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortKey =
      software.amazon.awssdk.services.datazone.model.SortKey.UPDATED_AT
  }
}
