package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SingleSignOn(
    `type`: Optional[zio.aws.datazone.model.AuthType] = Optional.Absent,
    userAssignment: Optional[zio.aws.datazone.model.UserAssignment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SingleSignOn = {
    import SingleSignOn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SingleSignOn
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(userAssignment.map(value => value.unwrap))(
        _.userAssignment
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SingleSignOn.ReadOnly =
    zio.aws.datazone.model.SingleSignOn.wrap(buildAwsValue())
}
object SingleSignOn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SingleSignOn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SingleSignOn =
      zio.aws.datazone.model.SingleSignOn(
        `type`.map(value => value),
        userAssignment.map(value => value)
      )
    def `type`: Optional[zio.aws.datazone.model.AuthType]
    def userAssignment: Optional[zio.aws.datazone.model.UserAssignment]
    def getType: ZIO[Any, AwsError, zio.aws.datazone.model.AuthType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserAssignment
        : ZIO[Any, AwsError, zio.aws.datazone.model.UserAssignment] =
      AwsError.unwrapOptionField("userAssignment", userAssignment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SingleSignOn
  ) extends zio.aws.datazone.model.SingleSignOn.ReadOnly {
    override val `type`: Optional[zio.aws.datazone.model.AuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.datazone.model.AuthType.wrap(value))
    override val userAssignment
        : Optional[zio.aws.datazone.model.UserAssignment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAssignment())
        .map(value => zio.aws.datazone.model.UserAssignment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SingleSignOn
  ): zio.aws.datazone.model.SingleSignOn.ReadOnly = new Wrapper(impl)
}
