package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchTypesResultItem(
    assetTypeItem: Optional[zio.aws.datazone.model.AssetTypeItem] =
      Optional.Absent,
    formTypeItem: Optional[zio.aws.datazone.model.FormTypeData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchTypesResultItem = {
    import SearchTypesResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchTypesResultItem
      .builder()
      .optionallyWith(assetTypeItem.map(value => value.buildAwsValue()))(
        _.assetTypeItem
      )
      .optionallyWith(formTypeItem.map(value => value.buildAwsValue()))(
        _.formTypeItem
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchTypesResultItem.ReadOnly =
    zio.aws.datazone.model.SearchTypesResultItem.wrap(buildAwsValue())
}
object SearchTypesResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchTypesResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchTypesResultItem =
      zio.aws.datazone.model.SearchTypesResultItem(
        assetTypeItem.map(value => value.asEditable),
        formTypeItem.map(value => value.asEditable)
      )
    def assetTypeItem: Optional[zio.aws.datazone.model.AssetTypeItem.ReadOnly]
    def formTypeItem: Optional[zio.aws.datazone.model.FormTypeData.ReadOnly]
    def getAssetTypeItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.AssetTypeItem.ReadOnly] =
      AwsError.unwrapOptionField("assetTypeItem", assetTypeItem)
    def getFormTypeItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.FormTypeData.ReadOnly] =
      AwsError.unwrapOptionField("formTypeItem", formTypeItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchTypesResultItem
  ) extends zio.aws.datazone.model.SearchTypesResultItem.ReadOnly {
    override val assetTypeItem
        : Optional[zio.aws.datazone.model.AssetTypeItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetTypeItem())
        .map(value => zio.aws.datazone.model.AssetTypeItem.wrap(value))
    override val formTypeItem
        : Optional[zio.aws.datazone.model.FormTypeData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formTypeItem())
        .map(value => zio.aws.datazone.model.FormTypeData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchTypesResultItem
  ): zio.aws.datazone.model.SearchTypesResultItem.ReadOnly = new Wrapper(impl)
}
