package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectName,
  ProjectId,
  SyntheticTimestamp_date_time,
  DomainId,
  Description,
  CreatedBy
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProjectSummary(
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBy: CreatedBy,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    id: ProjectId,
    name: ProjectName,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ProjectSummary = {
    import ProjectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ProjectSummary
      .builder()
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(ProjectId.unwrap(id): java.lang.String)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ProjectSummary.ReadOnly =
    zio.aws.datazone.model.ProjectSummary.wrap(buildAwsValue())
}
object ProjectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ProjectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ProjectSummary =
      zio.aws.datazone.model.ProjectSummary(
        createdAt.map(value => value),
        createdBy,
        description.map(value => value),
        domainId,
        id,
        name,
        updatedAt.map(value => value)
      )
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def createdBy: CreatedBy
    def description: Optional[Description]
    def domainId: DomainId
    def id: ProjectId
    def name: ProjectName
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ProjectSummary
  ) extends zio.aws.datazone.model.ProjectSummary.ReadOnly {
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.id())
    override val name: ProjectName =
      zio.aws.datazone.model.primitives.ProjectName(impl.name())
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ProjectSummary
  ): zio.aws.datazone.model.ProjectSummary.ReadOnly = new Wrapper(impl)
}
