package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  ProjectName,
  MaxResults,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    domainIdentifier: DomainId,
    groupIdentifier: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    name: Optional[ProjectName] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    userIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListProjectsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(groupIdentifier.map(value => value: java.lang.String))(
        _.groupIdentifier
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(userIdentifier.map(value => value: java.lang.String))(
        _.userIdentifier
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListProjectsRequest.ReadOnly =
    zio.aws.datazone.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListProjectsRequest =
      zio.aws.datazone.model.ListProjectsRequest(
        domainIdentifier,
        groupIdentifier.map(value => value),
        maxResults.map(value => value),
        name.map(value => value),
        nextToken.map(value => value),
        userIdentifier.map(value => value)
      )
    def domainIdentifier: DomainId
    def groupIdentifier: Optional[String]
    def maxResults: Optional[MaxResults]
    def name: Optional[ProjectName]
    def nextToken: Optional[PaginationToken]
    def userIdentifier: Optional[String]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIdentifier", groupIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userIdentifier", userIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectsRequest
  ) extends zio.aws.datazone.model.ListProjectsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val groupIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIdentifier())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val name: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.ProjectName(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val userIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectsRequest
  ): zio.aws.datazone.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
