package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  MaxResults,
  DomainId,
  DataSourceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSourceRunsRequest(
    dataSourceIdentifier: DataSourceId,
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest = {
    import ListDataSourceRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest
      .builder()
      .dataSourceIdentifier(
        DataSourceId.unwrap(dataSourceIdentifier): java.lang.String
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListDataSourceRunsRequest.ReadOnly =
    zio.aws.datazone.model.ListDataSourceRunsRequest.wrap(buildAwsValue())
}
object ListDataSourceRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListDataSourceRunsRequest =
      zio.aws.datazone.model.ListDataSourceRunsRequest(
        dataSourceIdentifier,
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def dataSourceIdentifier: DataSourceId
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def status: Optional[zio.aws.datazone.model.DataSourceRunStatus]
    def getDataSourceIdentifier: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceIdentifier)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.DataSourceRunStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest
  ) extends zio.aws.datazone.model.ListDataSourceRunsRequest.ReadOnly {
    override val dataSourceIdentifier: DataSourceId =
      zio.aws.datazone.model.primitives
        .DataSourceId(impl.dataSourceIdentifier())
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val status: Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.DataSourceRunStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest
  ): zio.aws.datazone.model.ListDataSourceRunsRequest.ReadOnly = new Wrapper(
    impl
  )
}
