package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  MaxResults,
  AssetIdentifier,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssetRevisionsRequest(
    domainIdentifier: DomainId,
    identifier: AssetIdentifier,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest = {
    import ListAssetRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListAssetRevisionsRequest.ReadOnly =
    zio.aws.datazone.model.ListAssetRevisionsRequest.wrap(buildAwsValue())
}
object ListAssetRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListAssetRevisionsRequest =
      zio.aws.datazone.model.ListAssetRevisionsRequest(
        domainIdentifier,
        identifier,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: AssetIdentifier
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest
  ) extends zio.aws.datazone.model.ListAssetRevisionsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest
  ): zio.aws.datazone.model.ListAssetRevisionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
