package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GlossaryTermId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetGlossaryTermRequest(
    domainIdentifier: DomainId,
    identifier: GlossaryTermId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest = {
    import GetGlossaryTermRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(GlossaryTermId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetGlossaryTermRequest.ReadOnly =
    zio.aws.datazone.model.GetGlossaryTermRequest.wrap(buildAwsValue())
}
object GetGlossaryTermRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetGlossaryTermRequest =
      zio.aws.datazone.model
        .GetGlossaryTermRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: GlossaryTermId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryTermId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest
  ) extends zio.aws.datazone.model.GetGlossaryTermRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: GlossaryTermId =
      zio.aws.datazone.model.primitives.GlossaryTermId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryTermRequest
  ): zio.aws.datazone.model.GetGlossaryTermRequest.ReadOnly = new Wrapper(impl)
}
