package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{DataSourceRunId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetDataSourceRunRequest(
    domainIdentifier: DomainId,
    identifier: DataSourceRunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest = {
    import GetDataSourceRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(DataSourceRunId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetDataSourceRunRequest.ReadOnly =
    zio.aws.datazone.model.GetDataSourceRunRequest.wrap(buildAwsValue())
}
object GetDataSourceRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetDataSourceRunRequest =
      zio.aws.datazone.model
        .GetDataSourceRunRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: DataSourceRunId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, DataSourceRunId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest
  ) extends zio.aws.datazone.model.GetDataSourceRunRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: DataSourceRunId =
      zio.aws.datazone.model.primitives.DataSourceRunId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest
  ): zio.aws.datazone.model.GetDataSourceRunRequest.ReadOnly = new Wrapper(impl)
}
