package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{ShortDescription, GlossaryTermName}
import scala.jdk.CollectionConverters._
final case class DetailedGlossaryTerm(
    name: Optional[GlossaryTermName] = Optional.Absent,
    shortDescription: Optional[ShortDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm = {
    import DetailedGlossaryTerm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm
      .builder()
      .optionallyWith(
        name.map(value => GlossaryTermName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly =
    zio.aws.datazone.model.DetailedGlossaryTerm.wrap(buildAwsValue())
}
object DetailedGlossaryTerm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DetailedGlossaryTerm =
      zio.aws.datazone.model.DetailedGlossaryTerm(
        name.map(value => value),
        shortDescription.map(value => value)
      )
    def name: Optional[GlossaryTermName]
    def shortDescription: Optional[ShortDescription]
    def getName: ZIO[Any, AwsError, GlossaryTermName] =
      AwsError.unwrapOptionField("name", name)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm
  ) extends zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly {
    override val name: Optional[GlossaryTermName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.GlossaryTermName(value))
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value => zio.aws.datazone.model.primitives.ShortDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm
  ): zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly = new Wrapper(impl)
}
