package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GlossaryTermId, DomainId}
import scala.jdk.CollectionConverters._
final case class DeleteGlossaryTermRequest(
    domainIdentifier: DomainId,
    identifier: GlossaryTermId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest = {
    import DeleteGlossaryTermRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(GlossaryTermId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteGlossaryTermRequest.ReadOnly =
    zio.aws.datazone.model.DeleteGlossaryTermRequest.wrap(buildAwsValue())
}
object DeleteGlossaryTermRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteGlossaryTermRequest =
      zio.aws.datazone.model
        .DeleteGlossaryTermRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: GlossaryTermId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryTermId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest
  ) extends zio.aws.datazone.model.DeleteGlossaryTermRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: GlossaryTermId =
      zio.aws.datazone.model.primitives.GlossaryTermId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteGlossaryTermRequest
  ): zio.aws.datazone.model.DeleteGlossaryTermRequest.ReadOnly = new Wrapper(
    impl
  )
}
