package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{DataSourceId, DomainId}
import scala.jdk.CollectionConverters._
final case class DeleteDataSourceRequest(
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: DataSourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest = {
    import DeleteDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(DataSourceId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteDataSourceRequest.ReadOnly =
    zio.aws.datazone.model.DeleteDataSourceRequest.wrap(buildAwsValue())
}
object DeleteDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteDataSourceRequest =
      zio.aws.datazone.model.DeleteDataSourceRequest(
        clientToken.map(value => value),
        domainIdentifier,
        identifier
      )
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def identifier: DataSourceId
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest
  ) extends zio.aws.datazone.model.DeleteDataSourceRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDataSourceRequest
  ): zio.aws.datazone.model.DeleteDataSourceRequest.ReadOnly = new Wrapper(impl)
}
