package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataSourceConfigurationInput(
    glueRunConfiguration: Optional[
      zio.aws.datazone.model.GlueRunConfigurationInput
    ] = Optional.Absent,
    redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput = {
    import DataSourceConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput
      .builder()
      .optionallyWith(glueRunConfiguration.map(value => value.buildAwsValue()))(
        _.glueRunConfiguration
      )
      .optionallyWith(
        redshiftRunConfiguration.map(value => value.buildAwsValue())
      )(_.redshiftRunConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly =
    zio.aws.datazone.model.DataSourceConfigurationInput.wrap(buildAwsValue())
}
object DataSourceConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceConfigurationInput =
      zio.aws.datazone.model.DataSourceConfigurationInput(
        glueRunConfiguration.map(value => value.asEditable),
        redshiftRunConfiguration.map(value => value.asEditable)
      )
    def glueRunConfiguration
        : Optional[zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly]
    def redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly
    ]
    def getGlueRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("glueRunConfiguration", glueRunConfiguration)
    def getRedshiftRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftRunConfiguration",
      redshiftRunConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput
  ) extends zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly {
    override val glueRunConfiguration
        : Optional[zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glueRunConfiguration())
        .map(value =>
          zio.aws.datazone.model.GlueRunConfigurationInput.wrap(value)
        )
    override val redshiftRunConfiguration: Optional[
      zio.aws.datazone.model.RedshiftRunConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftRunConfiguration())
      .map(value =>
        zio.aws.datazone.model.RedshiftRunConfigurationInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput
  ): zio.aws.datazone.model.DataSourceConfigurationInput.ReadOnly = new Wrapper(
    impl
  )
}
