package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  LongDescription,
  GlossaryTermId,
  DomainId,
  GlossaryId,
  ShortDescription,
  GlossaryTermName
}
import scala.jdk.CollectionConverters._
final case class CreateGlossaryTermResponse(
    domainId: DomainId,
    glossaryId: GlossaryId,
    id: GlossaryTermId,
    longDescription: Optional[LongDescription] = Optional.Absent,
    name: GlossaryTermName,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    status: zio.aws.datazone.model.GlossaryTermStatus,
    termRelations: Optional[zio.aws.datazone.model.TermRelations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse = {
    import CreateGlossaryTermResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .glossaryId(GlossaryId.unwrap(glossaryId): java.lang.String)
      .id(GlossaryTermId.unwrap(id): java.lang.String)
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .name(GlossaryTermName.unwrap(name): java.lang.String)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .status(status.unwrap)
      .optionallyWith(termRelations.map(value => value.buildAwsValue()))(
        _.termRelations
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly =
    zio.aws.datazone.model.CreateGlossaryTermResponse.wrap(buildAwsValue())
}
object CreateGlossaryTermResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateGlossaryTermResponse =
      zio.aws.datazone.model.CreateGlossaryTermResponse(
        domainId,
        glossaryId,
        id,
        longDescription.map(value => value),
        name,
        shortDescription.map(value => value),
        status,
        termRelations.map(value => value.asEditable)
      )
    def domainId: DomainId
    def glossaryId: GlossaryId
    def id: GlossaryTermId
    def longDescription: Optional[LongDescription]
    def name: GlossaryTermName
    def shortDescription: Optional[ShortDescription]
    def status: zio.aws.datazone.model.GlossaryTermStatus
    def termRelations: Optional[zio.aws.datazone.model.TermRelations.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getGlossaryId: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(glossaryId)
    def getId: ZIO[Any, Nothing, GlossaryTermId] = ZIO.succeed(id)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getName: ZIO[Any, Nothing, GlossaryTermName] = ZIO.succeed(name)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.GlossaryTermStatus] =
      ZIO.succeed(status)
    def getTermRelations
        : ZIO[Any, AwsError, zio.aws.datazone.model.TermRelations.ReadOnly] =
      AwsError.unwrapOptionField("termRelations", termRelations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse
  ) extends zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly {
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val glossaryId: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.glossaryId())
    override val id: GlossaryTermId =
      zio.aws.datazone.model.primitives.GlossaryTermId(impl.id())
    override val longDescription: Optional[LongDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longDescription())
        .map(value => zio.aws.datazone.model.primitives.LongDescription(value))
    override val name: GlossaryTermName =
      zio.aws.datazone.model.primitives.GlossaryTermName(impl.name())
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value => zio.aws.datazone.model.primitives.ShortDescription(value))
    override val status: zio.aws.datazone.model.GlossaryTermStatus =
      zio.aws.datazone.model.GlossaryTermStatus.wrap(impl.status())
    override val termRelations
        : Optional[zio.aws.datazone.model.TermRelations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termRelations())
        .map(value => zio.aws.datazone.model.TermRelations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryTermResponse
  ): zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly = new Wrapper(
    impl
  )
}
