package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  FormTypeName,
  DomainId,
  Description
}
import scala.jdk.CollectionConverters._
final case class CreateFormTypeRequest(
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    model: zio.aws.datazone.model.Model,
    name: FormTypeName,
    owningProjectIdentifier: ProjectId,
    status: Optional[zio.aws.datazone.model.FormTypeStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest = {
    import CreateFormTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .model(model.buildAwsValue())
      .name(FormTypeName.unwrap(name): java.lang.String)
      .owningProjectIdentifier(
        ProjectId.unwrap(owningProjectIdentifier): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateFormTypeRequest.ReadOnly =
    zio.aws.datazone.model.CreateFormTypeRequest.wrap(buildAwsValue())
}
object CreateFormTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateFormTypeRequest =
      zio.aws.datazone.model.CreateFormTypeRequest(
        description.map(value => value),
        domainIdentifier,
        model.asEditable,
        name,
        owningProjectIdentifier,
        status.map(value => value)
      )
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def model: zio.aws.datazone.model.Model.ReadOnly
    def name: FormTypeName
    def owningProjectIdentifier: ProjectId
    def status: Optional[zio.aws.datazone.model.FormTypeStatus]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getModel: ZIO[Any, Nothing, zio.aws.datazone.model.Model.ReadOnly] =
      ZIO.succeed(model)
    def getName: ZIO[Any, Nothing, FormTypeName] = ZIO.succeed(name)
    def getOwningProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectIdentifier)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.FormTypeStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest
  ) extends zio.aws.datazone.model.CreateFormTypeRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val model: zio.aws.datazone.model.Model.ReadOnly =
      zio.aws.datazone.model.Model.wrap(impl.model())
    override val name: FormTypeName =
      zio.aws.datazone.model.primitives.FormTypeName(impl.name())
    override val owningProjectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives
        .ProjectId(impl.owningProjectIdentifier())
    override val status: Optional[zio.aws.datazone.model.FormTypeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.FormTypeStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateFormTypeRequest
  ): zio.aws.datazone.model.CreateFormTypeRequest.ReadOnly = new Wrapper(impl)
}
