package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  AssetName,
  AssetId,
  UpdatedBy,
  ProjectId,
  CreatedAt,
  Revision,
  Description,
  CreatedBy,
  TypeName,
  ListingId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AssetListingItem(
    additionalAttributes: Optional[
      zio.aws.datazone.model.AssetListingItemAdditionalAttributes
    ] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    entityId: Optional[AssetId] = Optional.Absent,
    entityRevision: Optional[Revision] = Optional.Absent,
    entityType: Optional[TypeName] = Optional.Absent,
    glossaryTerms: Optional[
      Iterable[zio.aws.datazone.model.DetailedGlossaryTerm]
    ] = Optional.Absent,
    listingCreatedBy: Optional[CreatedBy] = Optional.Absent,
    listingId: Optional[ListingId] = Optional.Absent,
    listingRevision: Optional[Revision] = Optional.Absent,
    listingUpdatedBy: Optional[UpdatedBy] = Optional.Absent,
    name: Optional[AssetName] = Optional.Absent,
    owningProjectId: Optional[ProjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetListingItem = {
    import AssetListingItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetListingItem
      .builder()
      .optionallyWith(additionalAttributes.map(value => value.buildAwsValue()))(
        _.additionalAttributes
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityId.map(value => AssetId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        entityRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.entityRevision)
      .optionallyWith(
        entityType.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.entityType)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .optionallyWith(
        listingCreatedBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.listingCreatedBy)
      .optionallyWith(
        listingId.map(value => ListingId.unwrap(value): java.lang.String)
      )(_.listingId)
      .optionallyWith(
        listingRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.listingRevision)
      .optionallyWith(
        listingUpdatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.listingUpdatedBy)
      .optionallyWith(
        name.map(value => AssetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owningProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.owningProjectId)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetListingItem.ReadOnly =
    zio.aws.datazone.model.AssetListingItem.wrap(buildAwsValue())
}
object AssetListingItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetListingItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetListingItem =
      zio.aws.datazone.model.AssetListingItem(
        additionalAttributes.map(value => value.asEditable),
        createdAt.map(value => value),
        description.map(value => value),
        entityId.map(value => value),
        entityRevision.map(value => value),
        entityType.map(value => value),
        glossaryTerms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listingCreatedBy.map(value => value),
        listingId.map(value => value),
        listingRevision.map(value => value),
        listingUpdatedBy.map(value => value),
        name.map(value => value),
        owningProjectId.map(value => value)
      )
    def additionalAttributes: Optional[
      zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly
    ]
    def createdAt: Optional[CreatedAt]
    def description: Optional[Description]
    def entityId: Optional[AssetId]
    def entityRevision: Optional[Revision]
    def entityType: Optional[TypeName]
    def glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]]
    def listingCreatedBy: Optional[CreatedBy]
    def listingId: Optional[ListingId]
    def listingRevision: Optional[Revision]
    def listingUpdatedBy: Optional[UpdatedBy]
    def name: Optional[AssetName]
    def owningProjectId: Optional[ProjectId]
    def getAdditionalAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityId: ZIO[Any, AwsError, AssetId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getEntityRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("entityRevision", entityRevision)
    def getEntityType: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("entityType", entityType)
    def getGlossaryTerms: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getListingCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("listingCreatedBy", listingCreatedBy)
    def getListingId: ZIO[Any, AwsError, ListingId] =
      AwsError.unwrapOptionField("listingId", listingId)
    def getListingRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("listingRevision", listingRevision)
    def getListingUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("listingUpdatedBy", listingUpdatedBy)
    def getName: ZIO[Any, AwsError, AssetName] =
      AwsError.unwrapOptionField("name", name)
    def getOwningProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("owningProjectId", owningProjectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingItem
  ) extends zio.aws.datazone.model.AssetListingItem.ReadOnly {
    override val additionalAttributes: Optional[
      zio.aws.datazone.model.AssetListingItemAdditionalAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributes())
      .map(value =>
        zio.aws.datazone.model.AssetListingItemAdditionalAttributes.wrap(value)
      )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val entityId: Optional[AssetId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.datazone.model.primitives.AssetId(value))
    override val entityRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
    override val entityType: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.entityType())
      .map(value => zio.aws.datazone.model.primitives.TypeName(value))
    override val glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.DetailedGlossaryTerm.wrap(item)
          }.toList
        )
    override val listingCreatedBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.listingCreatedBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val listingId: Optional[ListingId] = zio.aws.core.internal
      .optionalFromNullable(impl.listingId())
      .map(value => zio.aws.datazone.model.primitives.ListingId(value))
    override val listingRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.listingRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
    override val listingUpdatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.listingUpdatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
    override val name: Optional[AssetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.AssetName(value))
    override val owningProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetListingItem
  ): zio.aws.datazone.model.AssetListingItem.ReadOnly = new Wrapper(impl)
}
