package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  AssetId,
  ProjectId,
  CreatedAt,
  Revision,
  Forms,
  TypeName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AssetListing(
    assetId: Optional[AssetId] = Optional.Absent,
    assetRevision: Optional[Revision] = Optional.Absent,
    assetType: Optional[TypeName] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    forms: Optional[Forms] = Optional.Absent,
    glossaryTerms: Optional[
      Iterable[zio.aws.datazone.model.DetailedGlossaryTerm]
    ] = Optional.Absent,
    owningProjectId: Optional[ProjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetListing = {
    import AssetListing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetListing
      .builder()
      .optionallyWith(
        assetId.map(value => AssetId.unwrap(value): java.lang.String)
      )(_.assetId)
      .optionallyWith(
        assetRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.assetRevision)
      .optionallyWith(
        assetType.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.assetType)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        forms.map(value => Forms.unwrap(value): java.lang.String)
      )(_.forms)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .optionallyWith(
        owningProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.owningProjectId)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetListing.ReadOnly =
    zio.aws.datazone.model.AssetListing.wrap(buildAwsValue())
}
object AssetListing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetListing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetListing =
      zio.aws.datazone.model.AssetListing(
        assetId.map(value => value),
        assetRevision.map(value => value),
        assetType.map(value => value),
        createdAt.map(value => value),
        forms.map(value => value),
        glossaryTerms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        owningProjectId.map(value => value)
      )
    def assetId: Optional[AssetId]
    def assetRevision: Optional[Revision]
    def assetType: Optional[TypeName]
    def createdAt: Optional[CreatedAt]
    def forms: Optional[Forms]
    def glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]]
    def owningProjectId: Optional[ProjectId]
    def getAssetId: ZIO[Any, AwsError, AssetId] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getAssetRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("assetRevision", assetRevision)
    def getAssetType: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("assetType", assetType)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getForms: ZIO[Any, AwsError, Forms] =
      AwsError.unwrapOptionField("forms", forms)
    def getGlossaryTerms: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getOwningProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("owningProjectId", owningProjectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetListing
  ) extends zio.aws.datazone.model.AssetListing.ReadOnly {
    override val assetId: Optional[AssetId] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.datazone.model.primitives.AssetId(value))
    override val assetRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.assetRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
    override val assetType: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.assetType())
      .map(value => zio.aws.datazone.model.primitives.TypeName(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val forms: Optional[Forms] = zio.aws.core.internal
      .optionalFromNullable(impl.forms())
      .map(value => zio.aws.datazone.model.primitives.Forms(value))
    override val glossaryTerms
        : Optional[List[zio.aws.datazone.model.DetailedGlossaryTerm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.DetailedGlossaryTerm.wrap(item)
          }.toList
        )
    override val owningProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetListing
  ): zio.aws.datazone.model.AssetListing.ReadOnly = new Wrapper(impl)
}
