package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  AssetName,
  GlossaryTermId,
  ProjectId,
  CreatedAt,
  AssetIdentifier,
  DomainId,
  Revision,
  ExternalIdentifier,
  Description,
  CreatedBy,
  AssetTypeIdentifier
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AssetItem(
    additionalAttributes: Optional[
      zio.aws.datazone.model.AssetItemAdditionalAttributes
    ] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    externalIdentifier: Optional[ExternalIdentifier] = Optional.Absent,
    firstRevisionCreatedAt: Optional[CreatedAt] = Optional.Absent,
    firstRevisionCreatedBy: Optional[CreatedBy] = Optional.Absent,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    identifier: AssetIdentifier,
    name: AssetName,
    owningProjectId: ProjectId,
    typeIdentifier: AssetTypeIdentifier,
    typeRevision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AssetItem = {
    import AssetItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AssetItem
      .builder()
      .optionallyWith(additionalAttributes.map(value => value.buildAwsValue()))(
        _.additionalAttributes
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        externalIdentifier.map(value =>
          ExternalIdentifier.unwrap(value): java.lang.String
        )
      )(_.externalIdentifier)
      .optionallyWith(
        firstRevisionCreatedAt.map(value => CreatedAt.unwrap(value): Instant)
      )(_.firstRevisionCreatedAt)
      .optionallyWith(
        firstRevisionCreatedBy.map(value =>
          CreatedBy.unwrap(value): java.lang.String
        )
      )(_.firstRevisionCreatedBy)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .name(AssetName.unwrap(name): java.lang.String)
      .owningProjectId(ProjectId.unwrap(owningProjectId): java.lang.String)
      .typeIdentifier(
        AssetTypeIdentifier.unwrap(typeIdentifier): java.lang.String
      )
      .typeRevision(Revision.unwrap(typeRevision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AssetItem.ReadOnly =
    zio.aws.datazone.model.AssetItem.wrap(buildAwsValue())
}
object AssetItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AssetItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AssetItem =
      zio.aws.datazone.model.AssetItem(
        additionalAttributes.map(value => value.asEditable),
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        externalIdentifier.map(value => value),
        firstRevisionCreatedAt.map(value => value),
        firstRevisionCreatedBy.map(value => value),
        glossaryTerms.map(value => value),
        identifier,
        name,
        owningProjectId,
        typeIdentifier,
        typeRevision
      )
    def additionalAttributes: Optional[
      zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly
    ]
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[Description]
    def domainId: DomainId
    def externalIdentifier: Optional[ExternalIdentifier]
    def firstRevisionCreatedAt: Optional[CreatedAt]
    def firstRevisionCreatedBy: Optional[CreatedBy]
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def identifier: AssetIdentifier
    def name: AssetName
    def owningProjectId: ProjectId
    def typeIdentifier: AssetTypeIdentifier
    def typeRevision: Revision
    def getAdditionalAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getExternalIdentifier: ZIO[Any, AwsError, ExternalIdentifier] =
      AwsError.unwrapOptionField("externalIdentifier", externalIdentifier)
    def getFirstRevisionCreatedAt: ZIO[Any, AwsError, CreatedAt] = AwsError
      .unwrapOptionField("firstRevisionCreatedAt", firstRevisionCreatedAt)
    def getFirstRevisionCreatedBy: ZIO[Any, AwsError, CreatedBy] = AwsError
      .unwrapOptionField("firstRevisionCreatedBy", firstRevisionCreatedBy)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getOwningProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectId)
    def getTypeIdentifier: ZIO[Any, Nothing, AssetTypeIdentifier] =
      ZIO.succeed(typeIdentifier)
    def getTypeRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AssetItem
  ) extends zio.aws.datazone.model.AssetItem.ReadOnly {
    override val additionalAttributes: Optional[
      zio.aws.datazone.model.AssetItemAdditionalAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributes())
      .map(value =>
        zio.aws.datazone.model.AssetItemAdditionalAttributes.wrap(value)
      )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val externalIdentifier: Optional[ExternalIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIdentifier())
        .map(value =>
          zio.aws.datazone.model.primitives.ExternalIdentifier(value)
        )
    override val firstRevisionCreatedAt: Optional[CreatedAt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstRevisionCreatedAt())
        .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val firstRevisionCreatedBy: Optional[CreatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstRevisionCreatedBy())
        .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val name: AssetName =
      zio.aws.datazone.model.primitives.AssetName(impl.name())
    override val owningProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.owningProjectId())
    override val typeIdentifier: AssetTypeIdentifier =
      zio.aws.datazone.model.primitives
        .AssetTypeIdentifier(impl.typeIdentifier())
    override val typeRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.typeRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AssetItem
  ): zio.aws.datazone.model.AssetItem.ReadOnly = new Wrapper(impl)
}
