package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.CronString
import scala.jdk.CollectionConverters._
final case class ScheduleConfiguration(
    schedule: Optional[CronString] = Optional.Absent,
    timezone: Optional[zio.aws.datazone.model.Timezone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ScheduleConfiguration
      .builder()
      .optionallyWith(
        schedule.map(value => CronString.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(timezone.map(value => value.unwrap))(_.timezone)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ScheduleConfiguration.ReadOnly =
    zio.aws.datazone.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ScheduleConfiguration =
      zio.aws.datazone.model.ScheduleConfiguration(
        schedule.map(value => value),
        timezone.map(value => value)
      )
    def schedule: Optional[CronString]
    def timezone: Optional[zio.aws.datazone.model.Timezone]
    def getSchedule: ZIO[Any, AwsError, CronString] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getTimezone: ZIO[Any, AwsError, zio.aws.datazone.model.Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ScheduleConfiguration
  ) extends zio.aws.datazone.model.ScheduleConfiguration.ReadOnly {
    override val schedule: Optional[CronString] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value => zio.aws.datazone.model.primitives.CronString(value))
    override val timezone: Optional[zio.aws.datazone.model.Timezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezone())
        .map(value => zio.aws.datazone.model.Timezone.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ScheduleConfiguration
  ): zio.aws.datazone.model.ScheduleConfiguration.ReadOnly = new Wrapper(impl)
}
