package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{DomainId, Revision, AssetId}
import scala.jdk.CollectionConverters._
final case class RejectPredictionsResponse(
    assetId: AssetId,
    assetRevision: Revision,
    domainId: DomainId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse = {
    import RejectPredictionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse
      .builder()
      .assetId(AssetId.unwrap(assetId): java.lang.String)
      .assetRevision(Revision.unwrap(assetRevision): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly =
    zio.aws.datazone.model.RejectPredictionsResponse.wrap(buildAwsValue())
}
object RejectPredictionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RejectPredictionsResponse =
      zio.aws.datazone.model
        .RejectPredictionsResponse(assetId, assetRevision, domainId)
    def assetId: AssetId
    def assetRevision: Revision
    def domainId: DomainId
    def getAssetId: ZIO[Any, Nothing, AssetId] = ZIO.succeed(assetId)
    def getAssetRevision: ZIO[Any, Nothing, Revision] =
      ZIO.succeed(assetRevision)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse
  ) extends zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly {
    override val assetId: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.assetId())
    override val assetRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.assetRevision())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RejectPredictionsResponse
  ): zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
