package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{Revision, FormTypeName}
import scala.jdk.CollectionConverters._
final case class Import(name: FormTypeName, revision: Revision) {
  def buildAwsValue(): software.amazon.awssdk.services.datazone.model.Import = {
    import Import.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Import
      .builder()
      .name(FormTypeName.unwrap(name): java.lang.String)
      .revision(Revision.unwrap(revision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Import.ReadOnly =
    zio.aws.datazone.model.Import.wrap(buildAwsValue())
}
object Import {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Import] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Import =
      zio.aws.datazone.model.Import(name, revision)
    def name: FormTypeName
    def revision: Revision
    def getName: ZIO[Any, Nothing, FormTypeName] = ZIO.succeed(name)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Import
  ) extends zio.aws.datazone.model.Import.ReadOnly {
    override val name: FormTypeName =
      zio.aws.datazone.model.primitives.FormTypeName(impl.name())
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Import
  ): zio.aws.datazone.model.Import.ReadOnly = new Wrapper(impl)
}
