package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Revision, ListingId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetListingRequest(
    domainIdentifier: DomainId,
    identifier: ListingId,
    listingRevision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetListingRequest = {
    import GetListingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetListingRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(ListingId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        listingRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.listingRevision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetListingRequest.ReadOnly =
    zio.aws.datazone.model.GetListingRequest.wrap(buildAwsValue())
}
object GetListingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetListingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetListingRequest =
      zio.aws.datazone.model.GetListingRequest(
        domainIdentifier,
        identifier,
        listingRevision.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: ListingId
    def listingRevision: Optional[Revision]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, ListingId] = ZIO.succeed(identifier)
    def getListingRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("listingRevision", listingRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetListingRequest
  ) extends zio.aws.datazone.model.GetListingRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.identifier())
    override val listingRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.listingRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetListingRequest
  ): zio.aws.datazone.model.GetListingRequest.ReadOnly = new Wrapper(impl)
}
