package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DataSourceRunId,
  DataSourceId,
  DateTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DataSourceRunSummary(
    createdAt: DateTime,
    dataSourceId: DataSourceId,
    errorMessage: Optional[zio.aws.datazone.model.DataSourceErrorMessage] =
      Optional.Absent,
    id: DataSourceRunId,
    projectId: ProjectId,
    runStatisticsForAssets: Optional[
      zio.aws.datazone.model.RunStatisticsForAssets
    ] = Optional.Absent,
    startedAt: Optional[DateTime] = Optional.Absent,
    status: zio.aws.datazone.model.DataSourceRunStatus,
    stoppedAt: Optional[DateTime] = Optional.Absent,
    `type`: zio.aws.datazone.model.DataSourceRunType,
    updatedAt: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DataSourceRunSummary = {
    import DataSourceRunSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DataSourceRunSummary
      .builder()
      .createdAt(DateTime.unwrap(createdAt): Instant)
      .dataSourceId(DataSourceId.unwrap(dataSourceId): java.lang.String)
      .optionallyWith(errorMessage.map(value => value.buildAwsValue()))(
        _.errorMessage
      )
      .id(DataSourceRunId.unwrap(id): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        runStatisticsForAssets.map(value => value.buildAwsValue())
      )(_.runStatisticsForAssets)
      .optionallyWith(startedAt.map(value => DateTime.unwrap(value): Instant))(
        _.startedAt
      )
      .status(status.unwrap)
      .optionallyWith(stoppedAt.map(value => DateTime.unwrap(value): Instant))(
        _.stoppedAt
      )
      .`type`(`type`.unwrap)
      .updatedAt(DateTime.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DataSourceRunSummary.ReadOnly =
    zio.aws.datazone.model.DataSourceRunSummary.wrap(buildAwsValue())
}
object DataSourceRunSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DataSourceRunSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DataSourceRunSummary =
      zio.aws.datazone.model.DataSourceRunSummary(
        createdAt,
        dataSourceId,
        errorMessage.map(value => value.asEditable),
        id,
        projectId,
        runStatisticsForAssets.map(value => value.asEditable),
        startedAt.map(value => value),
        status,
        stoppedAt.map(value => value),
        `type`,
        updatedAt
      )
    def createdAt: DateTime
    def dataSourceId: DataSourceId
    def errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly]
    def id: DataSourceRunId
    def projectId: ProjectId
    def runStatisticsForAssets
        : Optional[zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly]
    def startedAt: Optional[DateTime]
    def status: zio.aws.datazone.model.DataSourceRunStatus
    def stoppedAt: Optional[DateTime]
    def `type`: zio.aws.datazone.model.DataSourceRunType
    def updatedAt: DateTime
    def getCreatedAt: ZIO[Any, Nothing, DateTime] = ZIO.succeed(createdAt)
    def getDataSourceId: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceId)
    def getErrorMessage: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly
    ] = AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getId: ZIO[Any, Nothing, DataSourceRunId] = ZIO.succeed(id)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getRunStatisticsForAssets: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly
    ] = AwsError.unwrapOptionField(
      "runStatisticsForAssets",
      runStatisticsForAssets
    )
    def getStartedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.DataSourceRunStatus] =
      ZIO.succeed(status)
    def getStoppedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getType: ZIO[Any, Nothing, zio.aws.datazone.model.DataSourceRunType] =
      ZIO.succeed(`type`)
    def getUpdatedAt: ZIO[Any, Nothing, DateTime] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceRunSummary
  ) extends zio.aws.datazone.model.DataSourceRunSummary.ReadOnly {
    override val createdAt: DateTime =
      zio.aws.datazone.model.primitives.DateTime(impl.createdAt())
    override val dataSourceId: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.dataSourceId())
    override val errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value => zio.aws.datazone.model.DataSourceErrorMessage.wrap(value))
    override val id: DataSourceRunId =
      zio.aws.datazone.model.primitives.DataSourceRunId(impl.id())
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val runStatisticsForAssets
        : Optional[zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runStatisticsForAssets())
        .map(value => zio.aws.datazone.model.RunStatisticsForAssets.wrap(value))
    override val startedAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val status: zio.aws.datazone.model.DataSourceRunStatus =
      zio.aws.datazone.model.DataSourceRunStatus.wrap(impl.status())
    override val stoppedAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val `type`: zio.aws.datazone.model.DataSourceRunType =
      zio.aws.datazone.model.DataSourceRunType.wrap(impl.`type`())
    override val updatedAt: DateTime =
      zio.aws.datazone.model.primitives.DateTime(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DataSourceRunSummary
  ): zio.aws.datazone.model.DataSourceRunSummary.ReadOnly = new Wrapper(impl)
}
