package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  AssetName,
  GlossaryTermId,
  ProjectId,
  DomainId,
  Revision,
  ExternalIdentifier,
  Description,
  ClientToken,
  AssetTypeIdentifier
}
import scala.jdk.CollectionConverters._
final case class CreateAssetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    externalIdentifier: Optional[ExternalIdentifier] = Optional.Absent,
    formsInput: Optional[Iterable[zio.aws.datazone.model.FormInput]] =
      Optional.Absent,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    name: AssetName,
    owningProjectIdentifier: ProjectId,
    predictionConfiguration: Optional[
      zio.aws.datazone.model.PredictionConfiguration
    ] = Optional.Absent,
    typeIdentifier: AssetTypeIdentifier,
    typeRevision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateAssetRequest = {
    import CreateAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateAssetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        externalIdentifier.map(value =>
          ExternalIdentifier.unwrap(value): java.lang.String
        )
      )(_.externalIdentifier)
      .optionallyWith(
        formsInput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.formsInput)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .name(AssetName.unwrap(name): java.lang.String)
      .owningProjectIdentifier(
        ProjectId.unwrap(owningProjectIdentifier): java.lang.String
      )
      .optionallyWith(
        predictionConfiguration.map(value => value.buildAwsValue())
      )(_.predictionConfiguration)
      .typeIdentifier(
        AssetTypeIdentifier.unwrap(typeIdentifier): java.lang.String
      )
      .optionallyWith(
        typeRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.typeRevision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateAssetRequest.ReadOnly =
    zio.aws.datazone.model.CreateAssetRequest.wrap(buildAwsValue())
}
object CreateAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateAssetRequest =
      zio.aws.datazone.model.CreateAssetRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainIdentifier,
        externalIdentifier.map(value => value),
        formsInput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        glossaryTerms.map(value => value),
        name,
        owningProjectIdentifier,
        predictionConfiguration.map(value => value.asEditable),
        typeIdentifier,
        typeRevision.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def externalIdentifier: Optional[ExternalIdentifier]
    def formsInput: Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]]
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def name: AssetName
    def owningProjectIdentifier: ProjectId
    def predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly]
    def typeIdentifier: AssetTypeIdentifier
    def typeRevision: Optional[Revision]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getExternalIdentifier: ZIO[Any, AwsError, ExternalIdentifier] =
      AwsError.unwrapOptionField("externalIdentifier", externalIdentifier)
    def getFormsInput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      AwsError.unwrapOptionField("formsInput", formsInput)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getOwningProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectIdentifier)
    def getPredictionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.PredictionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predictionConfiguration",
      predictionConfiguration
    )
    def getTypeIdentifier: ZIO[Any, Nothing, AssetTypeIdentifier] =
      ZIO.succeed(typeIdentifier)
    def getTypeRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("typeRevision", typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetRequest
  ) extends zio.aws.datazone.model.CreateAssetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val externalIdentifier: Optional[ExternalIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIdentifier())
        .map(value =>
          zio.aws.datazone.model.primitives.ExternalIdentifier(value)
        )
    override val formsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formsInput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormInput.wrap(item)
          }.toList
        )
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val name: AssetName =
      zio.aws.datazone.model.primitives.AssetName(impl.name())
    override val owningProjectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives
        .ProjectId(impl.owningProjectIdentifier())
    override val predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionConfiguration())
        .map(value =>
          zio.aws.datazone.model.PredictionConfiguration.wrap(value)
        )
    override val typeIdentifier: AssetTypeIdentifier =
      zio.aws.datazone.model.primitives
        .AssetTypeIdentifier(impl.typeIdentifier())
    override val typeRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.typeRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetRequest
  ): zio.aws.datazone.model.CreateAssetRequest.ReadOnly = new Wrapper(impl)
}
