package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudFormationProperties(templateUrl: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CloudFormationProperties = {
    import CloudFormationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CloudFormationProperties
      .builder()
      .templateUrl(templateUrl: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CloudFormationProperties.ReadOnly =
    zio.aws.datazone.model.CloudFormationProperties.wrap(buildAwsValue())
}
object CloudFormationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CloudFormationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CloudFormationProperties =
      zio.aws.datazone.model.CloudFormationProperties(templateUrl)
    def templateUrl: String
    def getTemplateUrl: ZIO[Any, Nothing, String] = ZIO.succeed(templateUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CloudFormationProperties
  ) extends zio.aws.datazone.model.CloudFormationProperties.ReadOnly {
    override val templateUrl: String = impl.templateUrl(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CloudFormationProperties
  ): zio.aws.datazone.model.CloudFormationProperties.ReadOnly = new Wrapper(
    impl
  )
}
