package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{SubscriptionId, DomainId}
import scala.jdk.CollectionConverters._
final case class CancelSubscriptionRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest = {
    import CancelSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CancelSubscriptionRequest.ReadOnly =
    zio.aws.datazone.model.CancelSubscriptionRequest.wrap(buildAwsValue())
}
object CancelSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CancelSubscriptionRequest =
      zio.aws.datazone.model
        .CancelSubscriptionRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: SubscriptionId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest
  ) extends zio.aws.datazone.model.CancelSubscriptionRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionId =
      zio.aws.datazone.model.primitives.SubscriptionId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CancelSubscriptionRequest
  ): zio.aws.datazone.model.CancelSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
