package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait UserSearchType {
  def unwrap: software.amazon.awssdk.services.datazone.model.UserSearchType
}
object UserSearchType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.UserSearchType
  ): zio.aws.datazone.model.UserSearchType = value match {
    case software.amazon.awssdk.services.datazone.model.UserSearchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.UserSearchType.SSO_USER =>
      val r = SSO_USER
      r
    case software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_USER =>
      val r = DATAZONE_USER
      r
    case software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_SSO_USER =>
      val r = DATAZONE_SSO_USER
      r
    case software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_IAM_USER =>
      val r = DATAZONE_IAM_USER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.UserSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserSearchType =
      software.amazon.awssdk.services.datazone.model.UserSearchType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSO_USER extends zio.aws.datazone.model.UserSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserSearchType =
      software.amazon.awssdk.services.datazone.model.UserSearchType.SSO_USER
  }
  case object DATAZONE_USER extends zio.aws.datazone.model.UserSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserSearchType =
      software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_USER
  }
  case object DATAZONE_SSO_USER extends zio.aws.datazone.model.UserSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserSearchType =
      software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_SSO_USER
  }
  case object DATAZONE_IAM_USER extends zio.aws.datazone.model.UserSearchType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserSearchType =
      software.amazon.awssdk.services.datazone.model.UserSearchType.DATAZONE_IAM_USER
  }
}
