package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{
  RequestReason,
  SubscriptionRequestId,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class UpdateSubscriptionRequestRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionRequestId,
    requestReason: RequestReason
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest = {
    import UpdateSubscriptionRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionRequestId.unwrap(identifier): java.lang.String)
      .requestReason(RequestReason.unwrap(requestReason): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.UpdateSubscriptionRequestRequest.ReadOnly =
    zio.aws.datazone.model.UpdateSubscriptionRequestRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriptionRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateSubscriptionRequestRequest =
      zio.aws.datazone.model.UpdateSubscriptionRequestRequest(
        domainIdentifier,
        identifier,
        requestReason
      )
    def domainIdentifier: DomainId
    def identifier: SubscriptionRequestId
    def requestReason: RequestReason
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionRequestId] =
      ZIO.succeed(identifier)
    def getRequestReason: ZIO[Any, Nothing, RequestReason] =
      ZIO.succeed(requestReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest
  ) extends zio.aws.datazone.model.UpdateSubscriptionRequestRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.identifier())
    override val requestReason: RequestReason =
      zio.aws.datazone.model.primitives.RequestReason(impl.requestReason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionRequestRequest
  ): zio.aws.datazone.model.UpdateSubscriptionRequestRequest.ReadOnly =
    new Wrapper(impl)
}
