package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  SubscriptionGrantId,
  DomainId,
  AssetId
}
import scala.jdk.CollectionConverters._
final case class UpdateSubscriptionGrantStatusRequest(
    assetIdentifier: AssetId,
    domainIdentifier: DomainId,
    failureCause: Optional[zio.aws.datazone.model.FailureCause] =
      Optional.Absent,
    identifier: SubscriptionGrantId,
    status: zio.aws.datazone.model.SubscriptionGrantStatus,
    targetName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest = {
    import UpdateSubscriptionGrantStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest
      .builder()
      .assetIdentifier(AssetId.unwrap(assetIdentifier): java.lang.String)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(failureCause.map(value => value.buildAwsValue()))(
        _.failureCause
      )
      .identifier(SubscriptionGrantId.unwrap(identifier): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(targetName.map(value => value: java.lang.String))(
        _.targetName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest.ReadOnly =
    zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriptionGrantStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest =
      zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest(
        assetIdentifier,
        domainIdentifier,
        failureCause.map(value => value.asEditable),
        identifier,
        status,
        targetName.map(value => value)
      )
    def assetIdentifier: AssetId
    def domainIdentifier: DomainId
    def failureCause: Optional[zio.aws.datazone.model.FailureCause.ReadOnly]
    def identifier: SubscriptionGrantId
    def status: zio.aws.datazone.model.SubscriptionGrantStatus
    def targetName: Optional[String]
    def getAssetIdentifier: ZIO[Any, Nothing, AssetId] =
      ZIO.succeed(assetIdentifier)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFailureCause
        : ZIO[Any, AwsError, zio.aws.datazone.model.FailureCause.ReadOnly] =
      AwsError.unwrapOptionField("failureCause", failureCause)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionGrantId] =
      ZIO.succeed(identifier)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.SubscriptionGrantStatus] =
      ZIO.succeed(status)
    def getTargetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetName", targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest
  ) extends zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest.ReadOnly {
    override val assetIdentifier: AssetId =
      zio.aws.datazone.model.primitives.AssetId(impl.assetIdentifier())
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val failureCause
        : Optional[zio.aws.datazone.model.FailureCause.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCause())
        .map(value => zio.aws.datazone.model.FailureCause.wrap(value))
    override val identifier: SubscriptionGrantId =
      zio.aws.datazone.model.primitives.SubscriptionGrantId(impl.identifier())
    override val status: zio.aws.datazone.model.SubscriptionGrantStatus =
      zio.aws.datazone.model.SubscriptionGrantStatus.wrap(impl.status())
    override val targetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateSubscriptionGrantStatusRequest
  ): zio.aws.datazone.model.UpdateSubscriptionGrantStatusRequest.ReadOnly =
    new Wrapper(impl)
}
