package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.TagKey
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: String,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UntagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UntagResourceRequest.ReadOnly =
    zio.aws.datazone.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UntagResourceRequest =
      zio.aws.datazone.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: String
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UntagResourceRequest
  ) extends zio.aws.datazone.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.datazone.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UntagResourceRequest
  ): zio.aws.datazone.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
