package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait SubscriptionStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.SubscriptionStatus
}
object SubscriptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.SubscriptionStatus
  ): zio.aws.datazone.model.SubscriptionStatus = value match {
    case software.amazon.awssdk.services.datazone.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionStatus.APPROVED =>
      val r = APPROVED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionStatus.REVOKED =>
      val r = REVOKED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPROVED extends zio.aws.datazone.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionStatus.APPROVED
  }
  case object REVOKED extends zio.aws.datazone.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionStatus.REVOKED
  }
  case object CANCELLED extends zio.aws.datazone.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionStatus.CANCELLED
  }
}
