package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchResultItem(
    assetListing: Optional[zio.aws.datazone.model.AssetListingItem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchResultItem = {
    import SearchResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchResultItem
      .builder()
      .optionallyWith(assetListing.map(value => value.buildAwsValue()))(
        _.assetListing
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchResultItem.ReadOnly =
    zio.aws.datazone.model.SearchResultItem.wrap(buildAwsValue())
}
object SearchResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchResultItem =
      zio.aws.datazone.model
        .SearchResultItem(assetListing.map(value => value.asEditable))
    def assetListing: Optional[zio.aws.datazone.model.AssetListingItem.ReadOnly]
    def getAssetListing
        : ZIO[Any, AwsError, zio.aws.datazone.model.AssetListingItem.ReadOnly] =
      AwsError.unwrapOptionField("assetListing", assetListing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchResultItem
  ) extends zio.aws.datazone.model.SearchResultItem.ReadOnly {
    override val assetListing
        : Optional[zio.aws.datazone.model.AssetListingItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetListing())
        .map(value => zio.aws.datazone.model.AssetListingItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchResultItem
  ): zio.aws.datazone.model.SearchResultItem.ReadOnly = new Wrapper(impl)
}
