package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class RunStatisticsForAssets(
    added: Optional[Integer] = Optional.Absent,
    failed: Optional[Integer] = Optional.Absent,
    skipped: Optional[Integer] = Optional.Absent,
    unchanged: Optional[Integer] = Optional.Absent,
    updated: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets = {
    import RunStatisticsForAssets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets
      .builder()
      .optionallyWith(added.map(value => value: java.lang.Integer))(_.added)
      .optionallyWith(failed.map(value => value: java.lang.Integer))(_.failed)
      .optionallyWith(skipped.map(value => value: java.lang.Integer))(_.skipped)
      .optionallyWith(unchanged.map(value => value: java.lang.Integer))(
        _.unchanged
      )
      .optionallyWith(updated.map(value => value: java.lang.Integer))(_.updated)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly =
    zio.aws.datazone.model.RunStatisticsForAssets.wrap(buildAwsValue())
}
object RunStatisticsForAssets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RunStatisticsForAssets =
      zio.aws.datazone.model.RunStatisticsForAssets(
        added.map(value => value),
        failed.map(value => value),
        skipped.map(value => value),
        unchanged.map(value => value),
        updated.map(value => value)
      )
    def added: Optional[Integer]
    def failed: Optional[Integer]
    def skipped: Optional[Integer]
    def unchanged: Optional[Integer]
    def updated: Optional[Integer]
    def getAdded: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("added", added)
    def getFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failed", failed)
    def getSkipped: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("skipped", skipped)
    def getUnchanged: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unchanged", unchanged)
    def getUpdated: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets
  ) extends zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly {
    override val added: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.added())
      .map(value => value: Integer)
    override val failed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value => value: Integer)
    override val skipped: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.skipped())
      .map(value => value: Integer)
    override val unchanged: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.unchanged())
      .map(value => value: Integer)
    override val updated: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.updated())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RunStatisticsForAssets
  ): zio.aws.datazone.model.RunStatisticsForAssets.ReadOnly = new Wrapper(impl)
}
