package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListProjectMembershipsResponse(
    members: Iterable[zio.aws.datazone.model.ProjectMember],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse = {
    import ListProjectMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse
      .builder()
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly =
    zio.aws.datazone.model.ListProjectMembershipsResponse.wrap(buildAwsValue())
}
object ListProjectMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListProjectMembershipsResponse =
      zio.aws.datazone.model.ListProjectMembershipsResponse(
        members.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def members: List[zio.aws.datazone.model.ProjectMember.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getMembers: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.ProjectMember.ReadOnly
    ]] = ZIO.succeed(members)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse
  ) extends zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly {
    override val members: List[zio.aws.datazone.model.ProjectMember.ReadOnly] =
      impl
        .members()
        .asScala
        .map { item =>
          zio.aws.datazone.model.ProjectMember.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse
  ): zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly =
    new Wrapper(impl)
}
